<?php

namespace App\Http\Middleware;

use App\Models\General;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class KYC
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $basic = General::first();

        $validator = Validator::make($request->all(),[]);

        if($basic->identity_verification == 1 && Auth::user()->identity_verify != '2'){
            $validator->errors()->add('identity', 'Please kyc verification');
            return redirect()->route('user.kyc.index')->withErrors($validator)->withInput();
        }

        return $next($request);
    }
}
