<div class="nav-right-part nav-cus nav-right-part-desktop nav-right-part-mobile align-self-center">
    <select class="single-select" style="display: none;" id="langSel">
        <option value="en">English</option>
        @foreach($lang as $data)
        <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
        @endforeach
    </select>
    @guest
        <a class="btn btn-base" href="{{route('login')}}">{{__('Login')}}</a>
    @endguest
</div>
<nav class="navbar navbar-area navbar-expand-lg">
    <div class="container nav-container custom-container navbar-bg">
        <div class="responsive-mobile-menu">
            <button class="menu toggle-btn d-block d-lg-none" data-target="#hyipall_main_menu" 
            aria-expanded="false" aria-label="Toggle navigation">
                <span class="icon-left"></span>
                <span class="icon-right"></span>
            </button>
        </div>
        <div class="logo">
            <a href="{{url('/')}}"><img src="{{asset('public/images/logo/logo.png')}}" alt="img"></a>
        </div>
        <div class="collapse navbar-collapse" id="hyipall_main_menu">
            <ul class="navbar-nav menu-open text-lg-center">
                @auth
                    <li>
                        <a href="{{route('home')}}">{{__('Dashboard')}}</a>
                    </li>
                    @if ($general->ico == 1)
                    <li class="menu-item-has-children">
                        <a href="#">{{$general->cp_currency}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('wallet.index')}}">{{__('Wallets')}}</a></li>
                            <li><a href="{{route('my.wallet.transaction.log')}}">{{__('My Transaction Log')}}</a></li>
                            <li><a href="{{route('other.wallet.transaction.log')}}">{{__('Other Transaction Log')}}</a></li>
                        </ul>
                    </li>
                    @endif

                    <li class="menu-item-has-children">
                        <a href="#">{{__('Deposit')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('users.showDepositMethods')}}">{{__('Add Deposit')}}</a></li>
                            <li><a href="{{route('user.deposit.log')}}">{{__('Deposit Log')}}</a></li>
                        </ul>
                    </li>


                    <li class="menu-item-has-children">
                        <a href="#">{{__('Investment')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('invest.index')}}">{{__('Investment Plan')}}</a></li>
                            <li><a href="{{route('invest.log')}}">{{__('Invest Log')}}</a></li>
                        </ul>
                    </li>

                    <li class="menu-item-has-children">
                        <a href="#">{{__('Transaction')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('user.ref.index')}}">{{__('My Referral Tree')}}</a></li>
                            <li><a href="{{route('fund.transfer')}}">{{__('Fund Transfer')}}</a></li>
                            <li><a href="{{route('transaction.log')}}">{{__('Transaction Log')}}</a></li>
                            @if ($general->ico == 1)
                            <li><a href="{{route('purchase.coin')}}">{{__('MIN CRYPTO')}}</a></li>
                            @endif
                        </ul>
                    </li>

                    <li class="menu-item-has-children">
                        <a href="#">{{__('Withdraw')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('user.withdraw.method')}}">{{__('Withdraw')}}</a></li>
                            <li><a href="{{route('user.withdraw.log')}}">{{__('Withdraw Log')}}</a></li>
                        </ul>
                    </li>
                    @php $check_count = \App\Models\Support::where('status', 2)->get() @endphp
                    <li class="menu-item-has-children">
                        <a href="#">{{split_name(auth()->user()->name)[0]}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('profile.index')}}">{{__('Profile')}}</a></li>
                            <li><a href="{{route('user.kyc.index')}}">{{__('Kyc')}}</a></li>
                            <li><a href="{{route('customer.support.index')}}">{{__('Support')}} @if(count($check_count) == 0)  @else <span class="right badge bg-danger"> {{count($check_count)}} </span> @endif</a></li>
                            <li><a href="{{route('two.factor.index')}}">{{__('Security')}}</a></li>
                            <li><a onclick="event.preventDefault();document.getElementById('logout-form').submit();" href="{{route('logout')}}">{{__('Logout')}}</a></li>
                        </ul>
                    </li>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                        @csrf
                    </form>
                @else
                    <li>
                        <a href="{{url('/')}}">{{__('Home')}}</a>
                    </li>
                    @foreach($frontMenu as $data)
                        <li>
                            <a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a>
                        </li>
                    @endforeach
                    <li>
                        <a href="{{route('news.index')}}">{{__('News')}}</a>
                    </li>
                    <li>
                        <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
                    </li>
                @endif
            </ul>
        </div>
        <div class="nav-right-part nav-right-part-desktop align-self-center">
            <select class="single-select" style="display: none;" id="langSel">
                <option value="en">English</option>
                @foreach($lang as $data)
                <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
                @endforeach
            </select>
            @guest
                <a class="btn btn-base" href="{{route('login')}}">{{__('Login')}}</a>
            @endguest
        </div>
        <div class="nav-right-part nav-right-part-desktop nav-right-part-mobile align-self-center">
            <select class="single-select" style="display: none;" id="langSel">
                <option value="en">English</option>
                @foreach($lang as $data)
                <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
                @endforeach
            </select>
            @guest
                <a class="btn btn-base" href="{{route('login')}}">{{__('Login')}}</a>
            @endguest
        </div>
    </div>
</nav>