@extends($theme.'frontend.layouts.master')
@section('title', __('Stripe'))
@section('content')
<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Stripe Payment')}} </h2>
                    </div>
                    <form role="form" action="{{ route('ipn.stripe')}}" method="post" class="require-validation"
						data-cc-on-file="false"
						data-stripe-publishable-key="{{ $gatewayData->gateway_key_two }}"
						id="payment-form">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Name on Card')}} :</label>
                                    <input size="4" type="text" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Card Number')}} :</label>
                                    <input autocomplete="off" class="card-number" size="20" type="text">
                                </div>
                            </div>
							<div class='col-xs-12 col-md-4 form-group cvc required'>
								<label class='control-label'>{{__('CVC')}}</label>
								<input autocomplete='off' class='form-control card-cvc' placeholder='{{__('ex. 311')}}' size='4' type='text'>
							</div>
							<div class='col-xs-12 col-md-4 form-group expiration required'>
								<label class='control-label'>{{__('Expiration Month')}}</label> 
								<input class='form-control card-expiry-month' placeholder='MM' size='2' type='text'>
							</div>
							<div class='col-xs-12 col-md-4 form-group expiration required'>
								<label class='control-label'>{{__('Expiration Year')}}</label> 
								<input class='form-control card-expiry-year' placeholder='{{__('YYYY')}}' size='4' type='text'>
							</div>
							<div class='col-md-12 error form-group hide'>
								<div class='alert-danger alert'>{{__('Please correct the errors and try again.')}}</div>
							</div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Pay Now')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
@section('script')
	<script type="text/javascript" src="https://js.stripe.com/v2/"></script>
	<script type="text/javascript">
        $(function() {
            "use strict";
            $('.hide').css('display','none');
            var $form         = $(".require-validation");
            $('form.require-validation').bind('submit', function(e) {
                var $form         = $(".require-validation"),
                    inputSelector = ['input[type=email]', 'input[type=password]',
                        'input[type=text]', 'input[type=file]',
                        'textarea'].join(', '),
                    $inputs       = $form.find('.required').find(inputSelector),
                    $errorMessage = $form.find('div.error'),
                    valid         = true;
                $errorMessage.addClass('hide');

                $('.has-error').removeClass('has-error');
                $inputs.each(function(i, el) {
                    var $input = $(el);
                    if ($input.val() === '') {
                        $input.parent().addClass('has-error');
                        $errorMessage.removeClass('hide');
                        e.preventDefault();
                    }
                });
                if (!$form.data('cc-on-file')) {
                    e.preventDefault();
                    Stripe.setPublishableKey($form.data('stripe-publishable-key'));
                    Stripe.createToken({
                        number: $('.card-number').val(),
                        cvc: $('.card-cvc').val(),
                        exp_month: $('.card-expiry-month').val(),
                        exp_year: $('.card-expiry-year').val()
                    }, stripeResponseHandler);
                }

            });

            function stripeResponseHandler(status, response) {
                if (response.error) {
                    $('.error')
                        .removeClass('hide')
                        .find('.alert')
                        .text(response.error.message);
                } else {
                    // token contains id, last4, and card type
                    var token = response['id'];
                    // insert the token into the form so it gets submitted to the server
                    $form.find('input[type=text]').empty();
                    $form.append("<input type='hidden' name='stripeToken' value='" + token + "'/>");
                    $form.get(0).submit();
                }
            }

        })(jQuery); 
	</script>
@endsection
