@extends($theme.'frontend.layouts.master')
@section('title',__('Support Reply'))
@section('content')

<div class="blog-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h5 class="h3 mb-0">#{{$ticket_object->ticket}} - {{$ticket_object->subject}}</h5>
                        </div>
                        <div class="col-md-6 text-end">
                            @if($ticket_object->status == 1)
                            <button class="btn btn-warning btn-sm pull-end"> {{__('Opened')}}</button>
                            @elseif($ticket_object->status == 2)
                            <button type="button" class="btn btn-success btn-sm pull-end">  {{__('Answered')}} </button>
                            @elseif($ticket_object->status == 3)
                            <button type="button" class="btn btn-info btn-sm pull-end"> {{__('Customer Reply')}} </button>
                            @elseif($ticket_object->status == 9)
                            <button type="button" class="btn btn-danger btn-sm pull-end">  {{__('Closed')}} </button>
                            @endif
                            <a href="{{route('ticket.close', $ticket_object->ticket)}}" class="btn btn-danger btn-sm pull-end make-close-support">{{__('Make to Close')}}</a>
                        </div>
                    </div>
                    <div class="blog-details-page-content">
                        <div class="blog-comment">
                            <ul class="comment-list mt-lg-4 pt-2 mt-4">
                                @foreach($ticket_data as $data)
                                <li class="comment">
                                    <article class="comment-body comment-body-cus">
                                        <footer class="comment-meta">
                                            <div class="comment-author vcard">
                                                <a href="" rel="external nofollow ugc" class="url">
                                                    @if($data->type == 1)
                                                        {{$ticket_object->user_member->name}}
                                                    @elseif($data->type == 0)
                                                        {{__('Admin')}}
                                                    @endif
                                                </a>          
                                            </div>
                                            <div class="comment-metadata">
                                                <a href="#">{{$data->updated_at->format('d M, Y - h:i A') }}</a>                 
                                            </div>
                                        </footer>
                                        <div class="comment-content">
                                            <p>{!! $data->comment !!}</p>
                                        </div>          
                                    </article>
                                </li>
                                @endforeach
                            </ul>
                        </div> 
                        <form class="blog-comment-form" method="POST" action="{{route('store.customer.reply', $ticket_object->ticket)}}" accept-charset="UTF-8" class="form-horizontal form-bordered">
                            @csrf
                            <div class="mb-3">
                                <h4>{{__('Leave a Reply')}}</h4>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="single-input-inner style-bg">
                                        <textarea placeholder="Message" name="comment"></textarea>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-base border-radius-5">{{__('Post Comment')}}</button>
                                </div>
                            </div>
                        </form> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection