@extends($theme.'frontend.layouts.master')
@section('title',__('Home'))
@section('content')

    <div class="work-area common-pd-2 bg-none">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-4 col-md-6">
                    <div class="single-work text-center mg-top-180">
                        <span class="common-icon-circle bg-smile-green"><img src="{{asset('public/images/work/'.$workAreaFirst->icon)}}" alt="icon"></span>
                        <h4><a href="#">{{__($workAreaFirst->title)}}</a></h4>
                        <p>{{__(short_text($workAreaFirst->description,25))}}</p>
                        <a class="btn btn-plus" href="{{route('single.page',['class' => 'work','id'=>$workAreaFirst->id])}}"><i class="fa fa-plus"></i></a>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="row">
                        @foreach($workArea as $data)
                        <div class="col-lg-6 col-md-6">
                            <div class="single-work text-center">
                                <span class="common-icon-circle bg-pink"><img src="{{asset('public/images/work/'.$data->icon)}}" alt="icon"></span>
                                <h4><a href="#">{{__($data->title)}}</a></h4>
                                <p>{{__(short_text($data->description,25))}}</p>
                                <a class="btn btn-plus" href="{{route('single.page',['class' => 'work','id'=>$data->id])}}"><i class="fa fa-plus"></i></a>
                            </div>
                        </div>
                        @endforeach
                        <div class="col-lg-12 mb-5 mb-mg-0">
                            <div class="single-input-wrap text-center text-lg-right">
                                <input placeholder="Open an account - Enter you email" type="text" class="single-input">
                                <a class="btn btn-basic" href="{{route('register')}}">{{__('GO ON')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="shape-4">
        <div class="video-area-2 common-pd-bottom right-line-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 align-self-center">
                        <div class="section-title">
                            <h5 class="subtitle"><span></span>{{__($general->about_head)}}</h5>
                            <h3 class="title">{{__($general->about_title)}}</h3>
                            <p>{{__(short_text($general->about_body,50))}}</p>
                        </div>
                        <a class="btn btn-basic top-right-radius-0" href="{{route('single.page',['class' => 'About'])}}" onclick="window.location.href= {{route('single.page',['class' => 'About'])}}">{{__('Find Out More')}}</a>
                        <a class="video-play-btn" href="{{$general->about_video_url}}" data-effect="mfp-zoom-in"><i class="fa fa-play"></i></a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="single-about text-center bg-gradient">
                            <div class="thumb">
                                <img src="{{asset('public/images/about/one.png')}}" alt="icon">
                            </div>
                            <h5><a href="{{route('single.page',['class' => 'about_one'])}}">{{__($general->single_about1_title)}}</a></h5>
                            <p>{{__(short_text($general->single_about1_description, 20))}}</p>
                            <a class="btn btn-plus" href="{{route('single.page',['class' => 'about_one'])}}"><i class="fa fa-plus"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="single-about text-center bg-purple">
                            <div class="thumb">
                                <img src="{{asset('public/images/about/two.png')}}" alt="icon">
                            </div>
                            <h5><a href="{{route('single.page',['class' => 'about_two',])}}">{{__($general->single_about2_title)}}</a></h5>
                            <p>{{__(short_text($general->single_about2_description, 20))}}</p>
                            <a class="btn btn-plus" href="{{route('single.page',['class' => 'about_two'])}}"><i class="fa fa-plus"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="shape-2">
        <div class="why-choose-us-area pd-bottom-85">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5 align-self-center">
                        <div class="thumb item-bounce d-none d-lg-block">
                            <img src="{{url('/')}}/public/frontend/deepblue/img/why-choose-us/01.png" alt="img">
                        </div>
                    </div>
                    <div class="col-lg-7">
                       @foreach($services as $key => $data)
                        <div class="single-facility media">
                            <span class="number">{{$key+1}}</span>
                            <div class="thumb align-self-center">
                                <img src="{{asset('public/images/service/'.$data->icon)}}" alt="icon">
                            </div>
                            <div class="facility-details media-body">
                                <h5>{{__($data->title)}}</h5>
                                <p>{{__($data->description)}}</p>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        
        <div class="pricing-area pd-bottom-85">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="section-title text-center">
                            <h5 class="subtitle"><span></span>{{__($general->invest_head)}}</h5>
                            <h3 class="title">{{__($general->invest_title)}}</h3>
                            <div class="row justify-content-center">
                                <div class="col-lg-8">
                                    <p class="mb-0">{{__($general->invest_description)}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="pricing-tab">
                            <nav>
                                <div class="nav nav-tabs text-center" id="nav-tab">
                                    @if(count($roi_plans))
                                    <a class="btn ml-0 nav-item nav-link active" id="nav-monthly-tab" data-toggle="tab" href="#nav-roi">{{__('ROI Investment')}}</a>
                                    @endif
                                    @if(count($fixed_plans))
                                    <a class="btn nav-item nav-link" id="nav-yearly-tab" data-toggle="tab" href="#nav-fixed">{{__('Fixed Investment')}}</a>
                                    @endif
                                </div>
                            </nav>
                            <div class="tab-content" id="nav-tabContent">
                                <div class="tab-pane fade show active" id="nav-roi">
                                    <div class="row justify-content-center">
                                        @foreach($roi_plans as $data)
                                        @php
                                            $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                                        @endphp
                                            <div class="col-lg-4 col-md-6">
                                                <div class="single-pricing-wrap text-center">
                                                    <span class="animate-dots"></span>
                                                    <div class="price">{{__($data->percent)}}%</div>
                                                    <div class="thumb">
                                                        <img src="{{url('/')}}/public/frontend/deepblue/img/pricing/01.png" alt="icon">
                                                    </div>
                                                    <h5>{{__($data->name)}}</h5>
                                                    <ul>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('Minimum Deposit')}} {{$data->min_amount}}{{$general->currency}}</a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('Maximum Deposit')}} {{$data->max_amount}}{{$general->currency}}</a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                                            <span class="badge badge-pill badge-danger">@lang('Off')</span> @else <span class="badge badge-pill badge-success">@lang('On')</span> @endif </a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">
                                                                {{$data->percent}}% {{__('Payback')}}
                                                                {{trans($getTime->name)}}
                                                            </a></li>
                                                    </ul>
                                                    <a class="btn btn-plus" href="{{route('invest.index')}}"><i class="fa fa-plus"></i></a>
                                                    <a class="btn btn-white" href="{{route('invest.index')}}">{{__('Buy Now')}}</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="nav-fixed">
                                    <div class="row justify-content-center">
                                        @foreach($fixed_plans as $data)
                                        @php
                                            $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                                        @endphp
                                            <div class="col-lg-4 col-md-6">
                                                <div class="single-pricing-wrap text-center">
                                                    <span class="animate-dots"></span>
                                                    <div class="price">{{__($data->percent)}}%</div>
                                                    <div class="thumb">
                                                        <img src="{{url('/')}}/public/frontend/deepblue/img/pricing/01.png" alt="icon">
                                                    </div>
                                                    <h5>{{__($data->name)}}</h5>
                                                    <ul>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('ROI Action Lifetime TIMES')}}</a></li>
                                                        <li><a href="#" onclick="event.preventDefault()">{{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                                            <span class="badge badge-pill badge-danger">@lang('Off')</span> @else <span class="badge badge-pill badge-success">@lang('On')</span> @endif </a></li>
                                                        <li>
                                                            <a href="#" onclick="event.preventDefault()">
                                                                {{$data->percent}}% {{__('Payback')}}
                                                                {{trans($getTime->name)}}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                    <a class="btn btn-plus" href="{{route('invest.index')}}"><i class="fa fa-plus"></i></a>
                                                    <a class="btn btn-white" href="{{route('invest.index')}}">{{__('Buy Now')}}</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="team-area-2 common-pd-bottom">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-title text-center">
                        <h5 class="subtitle"><span></span>{{__($general->investor_head)}}</h5>
                        <h3 class="title">{{__($general->investor_title)}}</h3>
                        <p>{{__($general->investor_description)}}</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
               @foreach($investors as $data)
                <div class="col-lg-3 col-sm-6">
                    <div class="single-team-wrap text-center">
                        <div class="thumb">
                            <img src="{{asset('public/images/investor/'.$data->image)}}" alt="img">
                        </div>
                        <div class="team-details">
                            <h6>{{__($data->name)}}</h6>
                            <h6>{{__($data->designation)}}</h6>
                            <ul class="social-area">
                                @if(!is_null($data->fb_link))
                                <li><a href="{{$data->fb_link}}"><i class="fa fa-facebook-f"></i></a></li>
                                @endif
                                @if(!is_null($data->twitter_link))
                                <li><a href="{{$data->twitter_link}}"><i class="fa fa-twitter"></i></a></li>
                                @endif
                                @if(!is_null($data->linkedin_link))
                                <li><a href="{{$data->linkedin_link}}"><i class="fa fa-linkedin"></i></a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="news-slider-area">
                    <h6>{{__('Latest Top Investments News')}}</h6>
                    <div class="news-slider owl-carousel owl-theme">
                        @foreach($news as $data)
                        <div class="item"><img src="{{asset('public/images/news/'.$data->image)}}" alt="img"></div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="blog-area common-pd-bottom">
        <div class="container">
            <div class="row justify-content-center">
                @foreach($news as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="single-blog-wrap">
                        <div class="thumb">
                            <img src="{{asset('public/images/news/'.$data->image)}}" alt="img">
                        </div>
                        <div class="blog-details">
                            <h5>{{$data->title}}</h5>
                            <span><i class="fa fa-user"></i>{{__('Author')}}</span>
                            <span><i class="fa fa-clock-o"></i>{{date('F j, Y', strtotime($data->updated_at))}}</span>
                            <p>{!! short_text($data->description, 30) !!}</p>
                            <div class="blog-btn text-center">
                                <a class="btn btn-white bottom-right-radius-0" href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{__('Read More')}}<i class="fa fa-long-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="shape-5">
        <div class="partner-area common-pd-bottom-4 right-bottom-line-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="partner-slider owl-carousel owl-theme">
                            @foreach($partners as $data)
                                <div class="item">
                                    <a href="#" onclick="event.preventDefault()"><img src="{{asset('public/images/partner/'.$data->image)}}" alt="client"></a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop