@extends($theme.'frontend.layouts.master')
@section('title',__('Home'))
@section('content')
    <div class="about-area pd-top-120 pd-bottom-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-8">
                    <div class="about-thumb-inner pe-xl-5 me-xl-5 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay="0.3s">
                        <img class="main-img" src="{{asset('public/frontend/deepblack/img/about/1.png')}}" alt="img">
                    </div>
                </div>
                <div class="col-lg-6 align-self-center wow animated fadeInRight" data-wow-duration="1.5s" data-wow-delay="0.3s">
                    <div class="section-title mt-5 mt-lg-0 mb-0">
                        <h6 class="sub-title">{{__($general->about_head)}}</h6>
                        <h2 class="title">{{__($general->about_title)}}</h2>
                        <p class="content mb-4 mb-xl-5">{{__($general->about_body)}}</p>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="media image-hover-rotate">
                                    <div class="media-left me-3">
                                        <img class="rotate-img" src="{{asset('public/images/about/one.png')}}" alt="img">
                                    </div>
                                    <div class="media-body align-self-center">
                                        <h5 class="mb-0"><a href="{{route('single.page',['class' => 'about_one'])}}">{{__($general->single_about1_title)}}</a></h5>
                                        <p>{{__(short_text($general->single_about1_description, 20))}}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="media image-hover-rotate">
                                    <div class="media-left me-3">
                                        <img class="rotate-img" src="{{asset('public/images/about/two.png')}}" alt="img">
                                    </div>
                                    <div class="media-body align-self-center">
                                        <h5 class="mb-0"><a href="{{route('single.page',['class' => 'about_two',])}}">{{__($general->single_about2_title)}}</a></h5>
                                        <p>{{__(short_text($general->single_about2_description, 20))}}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a class="btn btn-base" href="{{route('single.page',['class' => 'About'])}}" onclick="window.location.href= {{route('single.page',['class' => 'about'])}}">{{__('About Us')}} <img src="{{asset('public/frontend/deepblack/img/right.svg')}}" alt="img"></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="feature-area bg-relative pd-top-115 pd-bottom-90">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="single-feature-inner style-2 text-center">
                        <div class="thumb">
                            <img src="{{asset('public/images/work/'.$workAreaFirst->icon)}}" alt="img">
                        </div>
                        <div class="details">
                            <h5>{{__($workAreaFirst->title)}}</h5>
                            <p class="mb-0">{{__(short_text($workAreaFirst->description,25))}}</p>
                        </div>
                        <div class="details">
                            <a class="btn btn-gray" href="{{route('single.page',['class' => 'work','id'=>$workAreaFirst->id])}}"><i class="fa fa-plus"></i></a>
                        </div>
                    </div>
                </div>
                @foreach($workArea as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="single-feature-inner style-2 text-center">
                        <div class="thumb">
                            <img src="{{asset('public/images/work/'.$data->icon)}}" alt="img">
                        </div>
                        <div class="details">
                            <h5>{{__($data->title)}}</h5>
                            <p class="mb-0">{{__(short_text($data->description,25))}}</p>
                        </div>
                        <div class="details">
                            <a class="btn btn-gray" href="{{route('single.page',['class' => 'work','id'=>$data->id])}}"><i class="fa fa-plus"></i></a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="faq-area pd-top-120 pd-bottom-100 bg-right-50 faq_bg_img">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="section-title mt-5 mt-lg-0">
                        <h6 class="sub-title">{{__('Ask Anything')}}</h6>
                        <h2 class="title">{{__('Asked any questions ?')}}</h2>
                    </div>
                    <div class="accordion accordion-inner mt-3" id="accordionExample">
                        @foreach ($faqs as $key => $data)
                        <div class="accordion-item bg-white border-color">
                            <h2 class="accordion-header" id="headingOne{{$data->id}}">
                                <button class="accordion-button @if($key == 0) @else collapsed @endif" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne{{$data->id}}" aria-expanded="@if($key == 0) true @else false @endif" aria-controls="collapseOne{{$data->id}}">
                                    {{__($data->question)}}
                                </button>
                            </h2>
                            <div id="collapseOne{{$data->id}}" class="accordion-collapse collapse @if($key == 0) show @endif" aria-labelledby="headingOne{{$data->id}}" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    {!! __($data->answer) !!}
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="work-process-area bg-relative pd-top-115 pd-bottom-100">
        <img class="position-center-left top_image_bounce" src="public/frontend/lightblue/img/transaction/6.png" alt="img">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-title text-center">
                        <h6 class="sub-title">{{__('OUR BEST SERVICES')}}</h6>
                        <h2 class="title">{{__('Your Path To Financial Prosperity')}}</h2>
                    </div>
                </div>
            </div>
            <ul class="process-2-inner p-0 m-0">
                @foreach($services as $key => $data)
                <li class="single-work-process-inner style-3 text-center">
                    @if($loop->last)
                    
                    @else 
                        <img class="right-icon-img" src="{{asset('public/frontend/lightblue/img/transaction/8.png')}}" alt="img">
                    @endif
                    <h4 class="counter-num">{{$key+1}}</h4>
                    <div class="thumb mb-4">
                        <img src="{{asset('public/images/service/'.$data->icon)}}" alt="img">
                    </div>
                    <div class="details">
                        <h5 class="process-count color-base mb-3">{{__($data->title)}}</h5>
                        <p class="mb-0">{{__($data->description)}}</p>
                    </div>
                </li>
                @endforeach
            </ul>
        </div>
    </div>

    <div class="pricing-area pd-top-120 pd-bottom-90">
        <div class="container">
            <div class="section-title text-center">
                <h6 class="sub-title">{{__($general->invest_head)}}</h6>
                <h2 class="title"><span>{{__($general->invest_title)}}</span></h2>
            </div>
            <nav class="text-center mb-4">
                <ul class="nav nav-tabs transaction-nav-tab style-2 d-inline-flex" id="myTab" role="tablist">
                    @if(count($roi_plans))
                    <li class="nav-item m-1" role="presentation">
                        <button class="nav-link active" id="nav-monthly-tab" data-bs-toggle="tab" data-bs-target="#nav-roi" type="button" role="tab" aria-controls="nav-roi" aria-selected="true"> {{__('ROI Investment')}} </button>
                    </li>
                    @endif
                    @if(count($fixed_plans))
                    <li class="nav-item m-1" role="presentation">
                        <button class="nav-link" id="nav-yearly-tab" data-bs-toggle="tab" data-bs-target="#nav-fixed" type="button" role="tab" aria-controls="nav-fixed" aria-selected="false">{{__('Fixed Investment')}}</button>
                    </li>
                    @endif
                </ul>
            </nav>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="nav-roi" role="tabpanel" aria-labelledby="nav-monthly-tab">
                    <div class="row">
                        @foreach($roi_plans as $data)
                        @php
                            $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                        @endphp
                        <div class="col-lg-4 col-md-6">
                            <div class="pricing-inner-wrap">
                                <div class="single-pricing-inner style-2">
                                    <div class="text-center border-bottom-1 pb-3 mb-4">
                                        <div class="icon">
                                            <img src="{{asset('public/frontend/lightblue/img/icon/34.svg')}}" alt="img">
                                        </div>
                                        <h4>{{__($data->name)}}</h4>
                                    </div>
                                    <ul>
                                        <li><i class="fa fa-chevron-right"></i> {{__('Minimum Deposit')}} {{$data->min_amount}} {{$general->currency}}</li>
                                        <li><i class="fa fa-chevron-right"></i> {{__('Maximum Deposit')}} {{$data->max_amount}} {{$general->currency}}</li>
                                        <li><i class="fa fa-chevron-right"></i> {{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</li>
                                        <li><i class="fa fa-chevron-right"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                            <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                        <li><i class="fa fa-chevron-right"></i> 
                                            {{$data->percent}}% {{__('Payback')}}
                                            {{trans($getTime->name)}}
                                        </li>
                                    </ul>
                                    <a class="btn btn-gray w-100" href="{{route('invest.index')}}">{{__('Buy Now')}}</a>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="tab-pane fade" id="nav-fixed" role="tabpanel" aria-labelledby="nav-yearly-tab">
                    <div class="row">
                        @foreach($fixed_plans as $data)
                        @php
                            $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                        @endphp
                        <div class="col-lg-4 col-md-6">
                            <div class="pricing-inner-wrap">
                                <div class="single-pricing-inner style-2">
                                    <div class="text-center border-bottom-1 pb-3 mb-4">
                                        <div class="icon">
                                            <img src="{{asset('public/frontend/lightblue/img/icon/35.svg')}}" alt="img">
                                        </div>
                                        <h4>{{__($data->name)}}</h4>
                                    </div>
                                    <ul>
                                        <li><i class="fa fa-chevron-right"></i> {{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</li>
                                        <li><i class="fa fa-chevron-right"></i> {{__('ROI Action Lifetime TIMES')}}</li>
                                        <li><i class="fa fa-chevron-right"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                            <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                        <li><i class="fa fa-chevron-right"></i> {{$data->percent}}% {{__('Payback')}}
                                            {{trans($getTime->name)}}
                                        </li> 
                                    </ul>
                                    <a class="btn btn-gray w-100" href="{{route('invest.index')}}">{{__('Buy Now')}}</a>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="profit-area pd-top-115 pd-bottom-90">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 mb-5 mb-lg-0">
                    <div class="section-title">
                        <h6 class="sub-title">{{__('PROFIT CALCULATOR')}}</h6>
                        <h2 class="title">{{__('Fund Your Account')}}</h2>
                    </div>
                    <div class="calculator">
                        <form class="profit-form-inner">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="single-input-inner style-border">
                                        <h5>{{__('Mining Plan Type')}}</h5>
                                        <select class="single-select" id="planType" data-all="{{$data}}">
                                            <option selected disabled>{{__('Select Plan Type')}}</option>
                                            <option value="0">{{$general->currency}}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 normalInvest">
                                    <div class="single-input-inner style-border">
                                        <h5>{{__('All Plan')}}</h5>
                                        <select class="single-select planSelect">
                                            <option selected disabled>{{__('Select Plan')}}</option>
                                            @foreach ($roi_plans as $data)
                                            <option value="{{$data->id}}" planDetail="{{$data}}">@switch($data->period)
                                                @case(1)
                                                {{__('Hourly')}} @break
                                                @case(24)
                                                {{__('Daily')}} @break
                                                @case(168)
                                                {{__('Weekly')}} @break
                                                @case(720)
                                                {{__('Monthly')}} @break
                                                @case(2880)
                                                {{__('Quarterly')}} @break
                                                @case(8640)
                                                {{__('Yearly')}} @break
                                            @endswitch for {{__('Min')}} {{$data->min_amount}} {{$general->currency}} - {{__('Max')}}  {{$data->max_amount}} {{$general->currency}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="single-input-inner style-border">
                                        <label>
                                            <h5>{{__('Enter Amount')}}</h5>
                                            <input id="investAmount" name="invest_amount" type="text" placeholder="00.00$">
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button class="btn btn-base subBtn" type="button">
                                        {{__('Submit Now')}}
                                        <img src="{{asset('public/frontend/lightblue/img/right.svg')}}" alt="img">
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="box-shadow text-center image-hover-rotate border-radius-5 p-4 mb-4">
                                <div class="thumb mb-2">
                                    <img class="rotate-img ps-xl-2" src="{{asset('public/frontend/lightblue/img/icon/40.svg')}}" alt="img">
                                </div>
                                <div class="details">
                                    <h3 class="color-base mb-1 roiPerc">0</h3>
                                    <h5 class="mb-0">{{__('Total Percent')}}</h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="box-shadow text-center image-hover-rotate border-radius-5 p-4 mb-4">
                                <div class="thumb mb-2">
                                    <img class="rotate-img ps-xl-2" src="{{asset('public/frontend/lightblue/img/icon/41.svg')}}" alt="img">
                                </div>
                                <div class="details">
                                    <h3 class="color-base mb-1 roiAction">0</h3>
                                    <h5 class="mb-0">{{__('Return Action')}}</h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="box-shadow text-center image-hover-rotate border-radius-5 p-4 mb-4">
                                <div class="thumb mb-2">
                                    <img class="rotate-img ps-xl-2" src="{{asset('public/frontend/lightblue/img/icon/42.svg')}}" alt="img">
                                </div>
                                <div class="details">
                                    <h3 class="color-base mb-1 roiMsg">0</h3>
                                    <h5 class="mb-0">{{__('Net Profit')}}</h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="box-shadow text-center image-hover-rotate border-radius-5 p-4 mb-4">
                                <div class="thumb mb-2">
                                    <img class="rotate-img ps-xl-2" src="{{asset('public/frontend/lightblue/img/icon/43.svg')}}" alt="img">
                                </div>
                                <div class="details">
                                    <h3 class="color-base mb-1 totalGetAmount">0</h3>
                                    <h5 class="mb-0">{{__('Total Return')}}</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="testimonial-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="section-title">
                        <h6 class="sub-title">{{__($general->investor_head)}}</h6>
                        <h2 class="title">{{__($general->investor_title)}}</h2>
                    </div>
                </div>
            </div>
            <div class="testimonial-slider-1 owl-carousel slider-control-round slider-control-dots slider-control-right-top">
                @foreach($investors as $data)
                <div class="item">
                    <div class="single-testimonial-inner bg-white">
                        <div class="thumb mb-4">
                            <img class="border-radius-5" src="{{asset('public/images/investor/'.$data->image)}}" alt="img">
                        </div>
                        <h5>{{__($data->name)}}</h5>
                        <p class="content">{{__($data->designation)}}</p>
                        <ul class="social-media">
                            @if(!is_null($data->fb_link))
                            <li><a href="{{$data->fb_link}}"><i class="fab fa-facebook-f"></i></a></li>
                            @endif
                            @if(!is_null($data->twitter_link))
                            <li><a href="{{$data->twitter_link}}"><i class="fab fa-twitter"></i></a></li>
                            @endif
                            @if(!is_null($data->linkedin_link))
                            <li><a href="{{$data->linkedin_link}}"><i class="fab fa-linkedin"></i></a></li>
                            @endif
                        </ul>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="transaction-area pd-top-90">
        <div class="container">
            <div class="row justify-content-center mb-4">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-title mb-0">
                        <h6 class="sub-title">{{__('RECENT TRANSACTION')}}</h6>
                        <h2 class="title">{{__('Your Money Working Harder For You')}}</h2>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-4 align-self-end">
                    <nav class="text-lg-center mb-4 text-lg-end mt-4 mt-lg-0">
                        <div class="nav nav-tabs transaction-nav-tab style-2 d-inline-flex" id="nav-tab" role="tablist">
                            <button class="nav-link active" id="nav-mission-tab" data-bs-toggle="tab" data-bs-target="#nav-mission" type="button" role="tab" aria-controls="nav-mission" aria-selected="true">Deposit</button>
                            <button class="nav-link" id="nav-vision-tab" data-bs-toggle="tab" data-bs-target="#nav-vision" type="button" role="tab" aria-controls="nav-vision" aria-selected="false">Withdraw</button>
                        </div>
                    </nav>
                </div>
            </div>
            <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade show active" id="nav-mission" role="tabpanel" aria-labelledby="nav-mission-tab">
                    <div class="table-responsive">
                        <table class="table transaction-table style-2">
                            <thead>
                                <tr>
                                    <th>{{__('Name')}}</th>
                                    <th>{{__('Date')}}</th>
                                    <th>{{__('Geteway')}}</th>
                                    <th>{{__('Amount')}}</th>
                                    <th class="text-end">{{__('Status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($deposits as $data)
                                <tr>
                                    <td>
                                        @if(!is_null($data->user->image))
                                        <img src="{{asset('public/images/user/'.$data->user->image)}}" alt="img">
                                        @endif
                                        <span class="name">{{$data->user->name}}</span>
                                    </td>
                                    <td>{{$data->created_at->format('d M Y')}}</td>
                                    <td>{{$data->gateway->name}}</td>
                                    <td>{{$data->usd_amo}} {{$general->currency}}</td>
                                    <td class="text-end">
                                        @if($data->status == 1)
                                            <span class="badge bg-success">@lang('Approved')</span>
                                        @else
                                            <span class="badge bg-warning">@lang('Panding')</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane fade" id="nav-vision" role="tabpanel" aria-labelledby="nav-vision-tab">
                    <div class="table-responsive">
                    <table class="table transaction-table style-2">
                        <thead>
                            <tr>
                                <th>{{__('Name')}}</th>
                                <th>{{__('Date')}}</th>
                                <th>{{__('Geteway')}}</th>
                                <th>{{__('Amount')}}</th>
                                <th class="text-end">{{__('Status')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($withdraw as $data)
                            <tr>
                                <td>
                                    @if(!is_null($data->user->image))
                                    <img src="{{asset('public/images/user/'.$data->user->image)}}" alt="img">
                                    @endif
                                    <span class="name">{{$data->user->name}}</span>
                                </td>
                                <td>{{$data->created_at->format('d M Y')}}</td>
                                <td>{{$data->method_name}}</td>
                                <td>{{$data->amount}} {{$data->method_cur}}</td>
                                <td class="text-end">
                                    @if($data->status == 1)
                                        <span class="badge bg-success">@lang('Accept')</span>
                                    @elseif($data->status == 0)
                                        <span class="badge bg-warning">@lang('Panding')</span>
                                    @elseif($data->status == 2)
                                        <span class="badge bg-danger">@lang('Reject')</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="blog-area pd-top-90 pd-bottom-90">
        <div class="container">
            <div class="section-title text-center">
                <h6 class="sub-title">{{__('LATEST NEWS')}}</h6>
                <h2 class="title">{{__('News And Articles')}}</h2>
            </div>
            <div class="row">
                @foreach($news as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="single-blog-list style-2">
                        <div class="thumb">
                            <img src="{{asset('public/images/news/'.$data->image)}}" alt="img">
                        </div>
                        <div class="details">
                            <ul class="blog-meta">
                                <li><span><i class="far fa-user"></i></span>{{__('By Author')}}</li>
                                <li><span><i class="far fa-clock"></i></span>{{date('F j, Y', strtotime($data->updated_at))}}</li>
                            </ul>
                            <h5 class="pb-4"><a href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{$data->title}}</a></h5>
                            <a class="read-more-text" href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{__('View More')}} <img class="ms-2 d-inline-block" src="{{__('public/frontend/lightblue/img/icon/53.svg')}}" alt="img"></a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <input type="hidden" value="{{$general->cp_currency}}" id="cp_currency">
    <input type="hidden" value="{{$general->currency}}" id="currency">
@stop